--[ja] ボスフォルダ関係の命令 

--[ja] 平均等取得用 
grade={
	Grade_Tier01=0,
	Grade_Tier02=1,
	Grade_Tier03=2,
	Grade_Tier04=3,
	Grade_Tier05=4,
	Grade_Tier06=5,
	Grade_Tier07=6,
	Grade_Tier08=7,
	Grade_Tier09=8,
	Grade_Tier10=9,
	Grade_Tier11=10,
	Grade_Tier12=11,
	Grade_Tier13=12,
	Grade_Tier14=13,
	Grade_Tier15=14,
	Grade_Tier16=15,
	Grade_Tier17=16,
	Grade_Tier18=17,
	Grade_Tier19=18,
	Grade_Tier20=19,
	Grade_Failed=20
};
local dif_list={
	'Difficulty_Beginner',
	'Difficulty_Easy',
	'Difficulty_Medium',
	'Difficulty_Hard',
	'Difficulty_Challenge',
	'Difficulty_Edit'
};

-- [ja] EXFolderに移ってから操作可能になるまでの時間 
function EXF_BEGIN_WAIT()
	return 0.5;
end;

--[ja] 現在開いているグループフォルダ名を取得 
function GetActiveGroupName()
	local group="";
	if _SONG() then
		group=_SONG():GetGroupName();
	elseif GAMESTATE:GetExpandedSectionName()~="" then
		group=GAMESTATE:GetExpandedSectionName();
	end;
	return group;
end;

--[ja] フォルダパス(グループ名) 
function GetExFolderPath(group)
	if FILEMAN:DoesFileExist("/Songs/"..group.."/group.ini") then
		return "/Songs/"..group.."/";
	elseif FILEMAN:DoesFileExist("/AdditionalSongs/"..group.."/group.ini") then
		return "/AdditionalSongs/"..group.."/";
	else
		return false;
	end;
end;

--[ja] group.iniを持っているか(グループ名) 
function HasGroupIni(group)
	local ret=false;
	if FILEMAN:DoesFileExist("/Songs/"..group.."/group.ini") 
		or FILEMAN:DoesFileExist("/AdditionalSongs/"..group.."/group.ini") then
		ret=true;
	else
		ret=false;
	end;
	return ret;
end;

-- [ja] EXFolderに移動できる条件がそろっているか 
function ISChallEXFolder()
-- [ja] いいか、このコメントは有効にすると死んでしまう危険なスクリプトだ。 
-- 　　 絶対に触るんじゃないぞ…！テスト用に作った、
-- 　　 無条件でEXFolderが選択できるようになるとかそんなんじゃないからな…！
--[[
if true then
	return true;
end;
--]]
	if _SONG() then
		local EXF_EXFolder=getenv("EXF_EXFolder");
		if EXF_EXFolder[GetActiveGroupName()]
			and GAMESTATE:GetCurrentStageIndex()>=_MAXSTAGE() then
			local best_grade=GetStageState("Grade","Last","-");
			if best_grade<=2 then
				return true;
			else
				return false;
			end;
		else
			return false;
		end;
	end;
	return false
end;

function IsChallEXFolder()
	return ISChallEXFolder();
end;

-- [ja] 全ステージのグループフォルダでEXFolderに移動できる条件がそろっているか 
function IsChallEXFolder_LastGroup()
	if not GAMESTATE:IsCourseMode() then
		local EXF_EXFolder=getenv("EXF_EXFolder");
		if GAMESTATE:GetCurrentStageIndex()>=_MAXSTAGE() then
			local ss=STATSMAN:GetPlayedStageStats(1);
			if ss then
				local song=ss:GetPlayedSongs();
				if song then
					if EXF_EXFolder[song[1]:GetGroupName()] then
						local best_grade=GetStageState("Grade","Last","-");
						if best_grade<=2 then
							return song[1]:GetGroupName();
						end;
					end;
				end;
			end;
		end;
	end;
	return nil;
end;

-- [ja] 現在開いているグループはEXFolderに移動できる条件がそろっているか 
function ISChallEXFolder_NowOpen()
	if HasGroupIni(GetActiveGroupName())
		and GAMESTATE:GetCurrentStageIndex()>=_MAXSTAGE() then
		local best_grade=GetStageState("Grade","Last","-");
		if best_grade<=2 then
		-- [ja] 下の4箇所のコメントを解除すると判定がより精密になる
		-- 　　（全曲出現条件を満たしていない場合はfalseになる　もちろん無茶苦茶重い）
		--	if GetEXFolder_SongCnt(GetActiveGroupName(),1)>0 then
				return true;
		--	else
		--		return false;
		--	end;
		else
			return false;
		end;
	else
		return false;
	end;
end;

function IsChallEXFolder_NowOpen()
	return ISChallEXFolder_NowOpen();
end;

-- [ja] EXFolderのライフ設定 
function EXFolderLifeSetting()
	if getenv("ExGroupName")~="" then
		local so;
		local exll
		if getenv("ExLifeLevel") then
			exll=getenv("ExLifeLevel");
		else
			exll="Normal"
		end;
		if not GAMESTATE:IsEventMode() then
			local lf=0;
			if exll~="Normal" and exll~="Hard" and exll~="HardNoRecover" 
				and exll~="Ultimate" 
				and exll~="NoRecover" and exll~="Suddendeath" then
				if exll=="MFC" or exll=="PFC" or exll=="1" then
					life="1 life";
					lf=1;
				else
					lf=tonumber(exll);
					life=exll.." lives";
				end;
				so="faildefault,battery,"..life.."";
			elseif exll=="HardNoRecover" then
				so="bar,failimmediate,norecover";
				setenv("ExLifeLevel","Hard");
			elseif exll=="NoRecover" then
				so="bar,failimmediate,norecover";
				setenv("ExLifeLevel","Normal");
			elseif exll=="Suddendeath" then
				so="bar,failimmediate,suddendeath";
			else
				so="bar,failimmediate,normal-drain";
			end;
			opt=so;
			if GetSMVersion()>30 then
				-- [ja] b4のライフはバグでうまく設定されない 
				-- [ja] 150301 : CS8.5を参考に作り直し 
				for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
					local ps=GAMESTATE:GetPlayerState(pn);
					local po;
					if lf>0 then
						po=ps:GetPlayerOptions('ModsLevel_Stage');
						po:LifeSetting('LifeType_Battery');
						po:BatteryLives(lf);
						po=ps:GetPlayerOptions('ModsLevel_Preferred');
						po:LifeSetting('LifeType_Battery');
						po:BatteryLives(lf);
					else
						if exll=="HardNoRecover" then
							po=ps:GetPlayerOptions('ModsLevel_Stage');
							po:DrainSetting('DrainType_NoRecover');
							po=ps:GetPlayerOptions('ModsLevel_Preferred');
							po:DrainSetting('DrainType_NoRecover');
						elseif exll=="NoRecover" then
							po=ps:GetPlayerOptions('ModsLevel_Stage');
							po:DrainSetting('DrainType_NoRecover');
							po=ps:GetPlayerOptions('ModsLevel_Preferred');
							po:DrainSetting('DrainType_NoRecover');
						elseif exll=="Suddendeath" then
							po=ps:GetPlayerOptions('ModsLevel_Stage');
							po:DrainSetting('DrainType_SuddenDeath');
							po=ps:GetPlayerOptions('ModsLevel_Preferred');
							po:DrainSetting('DrainType_SuddenDeath');
						else
							po=ps:GetPlayerOptions('ModsLevel_Stage');
							po:DrainSetting('DrainType_Normal');
							po=ps:GetPlayerOptions('ModsLevel_Preferred');
							po:DrainSetting('DrainType_Normal');
						end;
					end;
					MESSAGEMAN:Broadcast( "PlayerOptionsChanged", {PlayerNumber = pn} );
				end;
			else
				for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
					local ps = GAMESTATE:GetPlayerState(pn);
					local modstr = "default, " .. ps:GetPlayerOptionsString("ModsLevel_Preferred")..", "..opt;
					ps:SetPlayerOptions("ModsLevel_Preferred", modstr);
					ps:SetPlayerOptions('ModsLevel_Song', modstr);
				end;
				GAMESTATE:SetSongOptions( "ModsLevel_Stage", so );
				MESSAGEMAN:Broadcast( "SongOptionsChanged" );
			end;
		elseif GetSMVersion()>30 then
		-- [ja] Beta4以降のイベントモードはこっち 
			for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
				if GAMESTATE:IsPlayerEnabled(pn) then
					local ps=GAMESTATE:GetPlayerState(pn);
					if ps then
						local po=ps:GetPlayerOptions('ModsLevel_Preferred');
						po:FailSetting('FailType_Immediate');
						if exll~="Normal" and exll~="Hard" and exll~="HardNoRecover" 
							and exll~="Ultimate" 
							and exll~="NoRecover" and exll~="Suddendeath" then
							po:LifeSetting('LifeType_Battery');
							if exll=="MFC" or exll=="PFC" or exll=="1" then
								po:BatteryLives(1);
							else
								po:BatteryLives(tonumber(exll));
							end;
						elseif exll=="HardNoRecover" then
							po:LifeSetting('LifeType_Bar');
							po:DrainSetting('DrainType_NoRecover');
							setenv("ExLifeLevel","Hard");
						elseif exll=="NoRecover" then
							po:LifeSetting('LifeType_Bar');
							po:DrainSetting('DrainType_NoRecover');
							setenv("ExLifeLevel","Normal");
						elseif exll=="Suddendeath" then
							po:LifeSetting('LifeType_Bar');
							po:DrainSetting('DrainType_SuddenDeath');
						else
							po:LifeSetting('LifeType_Bar');
							po:DrainSetting('DrainType_Normal');
						end;
					end;
				end;
			end;
		else
		-- [ja] Beta3以前、EVENT Modeはこっち 
			GAMESTATE:ApplyGameCommand("mod,failarcade");
			MESSAGEMAN:Broadcast( "SongOptionsChanged" );
			if exll~="Normal" and exll~="Hard" and exll~="HardNoRecover" 
				and exll~="Ultimate" 
				and exll~="NoRecover" and exll~="Suddendeath" then
				GAMESTATE:ApplyGameCommand( "mod,battery");
				MESSAGEMAN:Broadcast( "SongOptionsChanged" );
				if exll=="MFC" or exll=="PFC" or exll=="1" then
					GAMESTATE:ApplyGameCommand( "mod,1lives");
					MESSAGEMAN:Broadcast( "SongOptionsChanged" );
				else
					GAMESTATE:ApplyGameCommand( "mod,"..exll.."lives");
					MESSAGEMAN:Broadcast( "SongOptionsChanged" );
				end;
			elseif exll=="HardNoRecover" then
				GAMESTATE:ApplyGameCommand( "mod,bar");
				MESSAGEMAN:Broadcast( "SongOptionsChanged" );
				GAMESTATE:ApplyGameCommand( "mod,norecover");
				MESSAGEMAN:Broadcast( "SongOptionsChanged" );
				setenv("ExLifeLevel","Hard");
			elseif exll=="NoRecover" then
				GAMESTATE:ApplyGameCommand( "mod,bar");
				MESSAGEMAN:Broadcast( "SongOptionsChanged" );
				GAMESTATE:ApplyGameCommand( "mod,norecover");
				MESSAGEMAN:Broadcast( "SongOptionsChanged" );
				setenv("ExLifeLevel","Normal");
			elseif exll=="Suddendeath" then
				GAMESTATE:ApplyGameCommand( "mod,bar");
				MESSAGEMAN:Broadcast( "SongOptionsChanged" );
				GAMESTATE:ApplyGameCommand( "mod,suddendeath");
				MESSAGEMAN:Broadcast( "SongOptionsChanged" );
			else
				GAMESTATE:ApplyGameCommand( "mod,bar");
				MESSAGEMAN:Broadcast( "SongOptionsChanged" );
				GAMESTATE:ApplyGameCommand( "mod,normal-drain");
				MESSAGEMAN:Broadcast( "SongOptionsChanged" );
			end;
		end;
	end;
end;

-- [ja] 現在のEXステージ数を返す（EXFolderモード専用） 
function GetEXFolderStage()
	local exstage=1;
	if getenv("ExFolderFlag") then
		-- [ja] Ex2選曲 
		if getenv("ExFolderFlag")=="Ex1Result" then
--			setenv("ExFolderFlag","Ex2SelectMusic");
			exstage=2;
		-- [ja] Ex2ゲーム中からバック 
		elseif getenv("ExFolderFlag")=="Ex2GamePlay" then
--			setenv("ExFolderFlag","Ex2SelectMusic");
			exstage=2;
		-- [ja] Ex2選曲中から多重読み込み 
		elseif getenv("ExFolderFlag")=="Ex2SelectMusic" then
--			setenv("ExFolderFlag","Ex2SelectMusic");
			exstage=2;
		-- [ja] Ex1ゲーム中からバック 
		elseif getenv("ExFolderFlag")=="Ex1GamePlay" then
--			setenv("ExFolderFlag","Ex1SelectMusic");
			exstage=1;
		-- [ja] Ex1選曲中から多重読み込み 
		elseif getenv("ExFolderFlag")=="Ex1SelectMusic" then
--			setenv("ExFolderFlag","Ex1SelectMusic");
			exstage=1;
		-- [ja] その他 
		else
			if GAMESTATE:IsExtraStage2() then
--				setenv("ExFolderFlag","Ex2SelectMusic");
				exstage=2;
			else
--				setenv("ExFolderFlag","Ex1SelectMusic");
				exstage=1;
			end;
		end;
	else
		if GAMESTATE:IsExtraStage2() then
--			setenv("ExFolderFlag","Ex2SelectMusic");
			exstage=2;
		else
--			setenv("ExFolderFlag","Ex1SelectMusic");
			exstage=1;
		end;
	end;
	return exstage;
end;

--[ja] 平均ステータス 第2パラメータは取得する内容（平均/MAX/MIN/ラスト） 第3パラメータは以上/以下（and over/and under） 
--[[
	例：過去[MAXSTAGE]ステージの平均ダンスポイント（％）を求め、1P、2Pの高いほうを返す
	ret = GetStageState("pdp", "AVG", "+")

	例：過去[MAXSTAGE]ステージの最高コンボ数を求め、1P、2Pの低いほうを返す
	ret = GetStageState("Combo", "MAX", "-")

	例：最終ステージのグレードを求め、1P、2Pの低い（※グレードは低いほうが上位）ほうを返す
	ret = GetStageState("Grade", "Last", "-")
--]]
function GetStageState(prm,mode,overunder)
	--[ja] STAGE 1の時は取得不可能 
	if GAMESTATE:GetCurrentStageIndex()<1 then return 0 end;
	local chk_stat={0,0,"",""};	--[ja] 第二パラメータが数値の場合 
	local sprm=string.lower(prm);
	local smode=string.lower(mode);
	local chk_loop=((smode=="last") and 1 or _MAXSTAGE());
	if sprm=="grade" then
		for p=1,2 do
			local pn=((p==1) and PLAYER_1 or PLAYER_2);
			for i=1,chk_loop do
			local ss=STATSMAN:GetPlayedStageStats(i);
				if GAMESTATE:IsPlayerEnabled(pn) then
					local pss_grade=ss:GetPlayerStageStats(pn):GetGrade();
					local chk_var=grade[pss_grade];
					if i==1 then
						chk_stat[p]=chk_var
					elseif smode=="max" then
						if chk_var>chk_stat[p] then chk_stat[p]=chk_var end;
					elseif smode=="min" then
						if chk_var<chk_stat[p] then chk_stat[p]=chk_var end;
					else
						chk_stat[p]=chk_stat[p]+chk_var;
					end;
				end;
			end;
			if smode=="avg" then chk_stat[p]=chk_stat[p]/chk_loop end;
		end;
	elseif sprm=="dancepoints" or sprm=="dp" then
		for p=1,2 do
			local pn=((p==1) and PLAYER_1 or PLAYER_2);
			for i=1,chk_loop do
			local ss=STATSMAN:GetPlayedStageStats(i);
				if GAMESTATE:IsPlayerEnabled(pn) then
					local chk_var=ss:GetPlayerStageStats(pn):GetActualDancePoints();
					if i==1 then
						chk_stat[p]=chk_var
					elseif smode=="max" then
						if chk_var>chk_stat[p] then chk_stat[p]=chk_var end;
					elseif smode=="min" then
						if chk_var<chk_stat[p] then chk_stat[p]=chk_var end;
					else
						chk_stat[p]=chk_stat[p]+chk_var;
					end;
				end;
			end;
			if smode=="avg" then chk_stat[p]=chk_stat[p]/chk_loop end;
		end;
	elseif sprm=="perdancepoints" or sprm=="pdp" then
		for p=1,2 do
			local pn=((p==1) and PLAYER_1 or PLAYER_2);
			for i=1,chk_loop do
			local ss=STATSMAN:GetPlayedStageStats(i);
				if GAMESTATE:IsPlayerEnabled(pn) then
					local chk_var=ss:GetPlayerStageStats(pn):GetPercentDancePoints();
					if i==1 then
						chk_stat[p]=chk_var
					elseif smode=="max" then
						if chk_var>chk_stat[p] then chk_stat[p]=chk_var end;
					elseif smode=="min" then
						if chk_var<chk_stat[p] then chk_stat[p]=chk_var end;
					else
						chk_stat[p]=chk_stat[p]+chk_var;
					end;
				end;
			end;
			if smode=="avg" then chk_stat[p]=chk_stat[p]/chk_loop end;
		end;
	elseif sprm=="combo" or sprm=="maxcombo" then
		for p=1,2 do
			local pn=((p==1) and PLAYER_1 or PLAYER_2);
			for i=1,chk_loop do
			local ss=STATSMAN:GetPlayedStageStats(i);
				if GAMESTATE:IsPlayerEnabled(pn) then
					local chk_var=ss:GetPlayerStageStats(pn):MaxCombo();
					if i==1 then
						chk_stat[p]=chk_var
					elseif smode=="max" then
						if chk_var>chk_stat[p] then chk_stat[p]=chk_var end;
					elseif smode=="min" then
						if chk_var<chk_stat[p] then chk_stat[p]=chk_var end;
					else
						chk_stat[p]=chk_stat[p]+chk_var;
					end;
				end;
			end;
			if smode=="avg" then chk_stat[p]=chk_stat[p]/chk_loop end;
		end;
	elseif sprm=="meter" then
	--[ja] Meterは#METERTYPEの値によって変わるのであまり使わないほうがいいかも 
		for p=1,2 do
			local pn=((p==1) and PLAYER_1 or PLAYER_2);
			for i=1,chk_loop do
			local ss=STATSMAN:GetPlayedStageStats(i);
				if GAMESTATE:IsPlayerEnabled(pn) then
					local steps=ss:GetPlayerStageStats(pn):GetPlayedSteps();
					local chk_var=steps[#steps]:GetMeter();
					if i==1 then
						chk_stat[p]=chk_var
					elseif smode=="max" then
						if chk_var>chk_stat[p] then chk_stat[p]=chk_var end;
					elseif smode=="min" then
						if chk_var<chk_stat[p] then chk_stat[p]=chk_var end;
					else
						chk_stat[p]=chk_stat[p]+chk_var;
					end;
				end;
			end;
			if smode=="avg" then chk_stat[p]=chk_stat[p]/chk_loop end;
		end;
	elseif sprm=="combo" or sprm=="maxcombo" then
		for p=1,2 do
			local pn=((p==1) and PLAYER_1 or PLAYER_2);
			for i=1,chk_loop do
			local ss=STATSMAN:GetPlayedStageStats(i);
				if GAMESTATE:IsPlayerEnabled(pn) then
					local chk_var=ss:GetPlayerStageStats(pn):MaxCombo();
					if i==1 then
						chk_stat[p]=chk_var
					elseif smode=="max" then
						if chk_var>chk_stat[p] then chk_stat[p]=chk_var end;
					elseif smode=="min" then
						if chk_var<chk_stat[p] then chk_stat[p]=chk_var end;
					else
						chk_stat[p]=chk_stat[p]+chk_var;
					end;
				end;
			end;
			if smode=="avg" then chk_stat[p]=chk_stat[p]/chk_loop end;
		end;
	elseif sprm=="song" then
	-- [ja] Last か Playのみ使用可能（未指定・不正の場合Play） 
	-- [ja] ステージ数 or 0を返す 
		local songs=STATSMAN:GetAccumPlayedStageStats():GetPlayedSongs();
		for i=#songs-_MAXSTAGE()+1,#songs do
			local ssong=string.lower(songs[i]:GetSongDir());
			if string.find(ssong,smode,0,true) then
				return i-(#songs-_MAXSTAGE());
			end;
		end;
		return 0;
	end;
	if not GAMESTATE:IsPlayerEnabled(PLAYER_2) then
		return chk_stat[1];
	elseif not GAMESTATE:IsPlayerEnabled(PLAYER_1) then
		return chk_stat[2];
	elseif string.lower(overunder)=="over" or overunder=="+" then
		return ((chk_stat[1]>=chk_stat[2]) and chk_stat[1] or chk_stat[2]);
	elseif string.lower(overunder)=="under" or overunder=="-" then
		return ((chk_stat[1]<=chk_stat[2]) and chk_stat[1] or chk_stat[2]);
	else
		return (chk_stat[1]+chk_stat[2])/2;
	end;
end;

-- [ja] group.iniから任意の値を取得 (グループ名,パラメータ名) 
function GetGroupParameter(group,prm)
	local gpath;
	if FILEMAN:DoesFileExist("/Songs/"..group.."/group.ini")  then
		gpath="/Songs/"..group.."/group.ini";
	elseif FILEMAN:DoesFileExist("/AdditionalSongs/"..group.."/group.ini") then
		gpath="/AdditionalSongs/"..group.."/group.ini";
	else
		return "";
	end;
	local f=RageFileUtil.CreateRageFile();
	f:Open(gpath,1);
	local tmp=GetSMParameter_f(f,prm);
	f:Close();
	f:destroy();
	return tmp;
end;

-- [ja] 曲の出現条件を確認する 
function GetEXFolder_ChkSongs(groupname,exstage)
	local load_cnt=0;
	local exsong_inf={};
	local exsong_fol={};
	-- [ja] 楽曲情報文字列（#ExtraXSongsの中身）
	local sys_songunlock=split(":",string.lower(GetGroupParameter(groupname,"Extra"..exstage.."Songs")));
	local sys_songunlockU=split(":",GetGroupParameter(groupname,"Extra"..exstage.."Songs"));
	-- [ja] 難易度別条件取得（曲切り替えのたびに代入） 
	local sys_songunlock_prm1;
	local sys_songunlock_prm1U;
	-- [ja] 取得した難易度別条件をさらにパラメータごとに分割 
	local sys_songunlock_prm2;
	local sys_songunlock_prm2U;
	local txt_folders=GetGroupParameter(groupname,"Extra"..exstage.."List");
	chk_folders=split(":",txt_folders);
	-- [ja] 選択可能な曲を取得 
	local str="";
	for j=1,#chk_folders do
		foldername=chk_folders[j];
		local gsong=GetFolder2Song(groupname,foldername);
		if gsong then
			local gsong_title=SplitTitle(gsong:GetDisplayFullTitle());
			exsong_inf[foldername.."-Banner"]=(gsong:HasBanner()) and gsong:GetBannerPath() or THEME:GetPathG("Common","fallback banner");
			exsong_inf[foldername.."-Jacket"]=(gsong:HasJacket()) and gsong:GetJacketPath() or
				(gsong:HasBackground() and gsong:GetBackgroundPath() or THEME:GetPathG("Common","fallback banner"));
			exsong_inf[foldername.."-Random"]="";
			exsong_inf[foldername.."-Title"]=gsong_title[1];
			exsong_inf[foldername.."-SubTitle"]=gsong_title[2];
			exsong_inf[foldername.."-Artist"]=gsong:GetDisplayArtist();
			exsong_inf[foldername.."-Color"]="";
			exsong_inf[foldername.."-Hidden"]=2;
			local sdif_list={
				'$',
				'%-beginner$',
				'%-easy$',
				'%-medium$',
				'%-hard$',
				'%-challenge$',
				'%-edit$'
			};
			-- [ja] 全譜面選択可能状態 
			local diflock={true,true,true,true,true,true}
			local expath=GetExFolderPath(groupname);
			rnd_folder="";
			sp_songtitle="";
			sp_songartist="";
			sp_songjacket={"",""};
			sp_songbanner={"",""};
			-- [ja] group.iniに記載されている条件を満たさない譜面のフラグをfalseにする
			for k=1,#sys_songunlock do 
				local diflock_chk=true;
				if string.find(sys_songunlock[k],""..string.lower(foldername).."|",1,true) then 
				-- [ja] この処理をしないとRandom使用時に誤作動が起こる 
				_t1,_t2=string.find(sys_songunlock[k],""..string.lower(foldername).."|",1,true);
					if _t1==1 then
						sys_songunlock_prm1=split("|",sys_songunlock[k]);
						sys_songunlock_prm1U=split("|",sys_songunlockU[k]);
						if #sys_songunlock_prm1>=2 then	-- [ja] 曲フォルダ名,条件1...となるのでパラメータが2つ異常ないと不正 
							for l=2,#sys_songunlock_prm1 do
								sys_songunlock_prm2=split(">",sys_songunlock_prm1[l]);
								sys_songunlock_prm2U=split(">",sys_songunlock_prm1U[l]);
								if #sys_songunlock_prm2>1 then	-- [ja] パラメータが2つ以上ない場合は不正な書式として無視する 
									if sys_songunlock_prm2[1]=="random" then
										local rnd_base=math.round(GetStageState("PDP", "Last", "+")*10000);
										exsong_inf[foldername.."-Random"]=sys_songunlock_prm2[(rnd_base%(#sys_songunlock_prm2-1))+2];
									elseif sys_songunlock_prm2[1]=="banner" then
										if FILEMAN:DoesFileExist(expath..""..sys_songunlock_prm2[2]) then
											exsong_inf[foldername.."-Banner"]=expath..""..sys_songunlock_prm2[2];
											if exsong_inf[foldername.."-Jacket"]==THEME:GetPathG("Common","fallback banner") then
												exsong_inf[foldername.."-Jacket"]=exsong_inf[foldername.."-Banner"];
											end;
										end;
									elseif sys_songunlock_prm2[1]=="jacket" then
										if FILEMAN:DoesFileExist(expath..""..sys_songunlock_prm2[2]) then
											exsong_inf[foldername.."-Jacket"]=expath..""..sys_songunlock_prm2[2];
										end;
									elseif sys_songunlock_prm2[1]=="hidden" then
										if sys_songunlock_prm2[2]=="1" then
											exsong_inf[foldername.."-Hidden"]=1;	-- [ja] 難易度表記 
										elseif sys_songunlock_prm2[2]=="2" then
											exsong_inf[foldername.."-Hidden"]=2;	-- [ja] 譜面情報 
										elseif sys_songunlock_prm2[2]=="3" then
											exsong_inf[foldername.."-Hidden"]=3;
										elseif sys_songunlock_prm2[2]=="4" then
											exsong_inf[foldername.."-Hidden"]=4;	-- [ja] スコアデータ 
										elseif sys_songunlock_prm2[2]=="5" then
											exsong_inf[foldername.."-Hidden"]=5;
										elseif sys_songunlock_prm2[2]=="6" or sys_songunlock_prm2[2]=="true" then
											exsong_inf[foldername.."-Hidden"]=6;
										elseif sys_songunlock_prm2[2]=="7" or sys_songunlock_prm2[2]=="all" then
											exsong_inf[foldername.."-Hidden"]=7;
										else
											exsong_inf[foldername.."-Hidden"]=0;
										end;
									elseif sys_songunlock_prm2[1]=="title" then
										exsong_inf[foldername.."-Title"]=sys_songunlock_prm2U[2];
										exsong_inf[foldername.."-SubTitle"]="";
									elseif sys_songunlock_prm2[1]=="artist" then
										exsong_inf[foldername.."-Artist"]=sys_songunlock_prm2U[2];
									elseif sys_songunlock_prm2[1]=="color" then
										exsong_inf[foldername.."-Color"]=sys_songunlock_prm2U[2];
									elseif #sys_songunlock_prm2==3 and diflock_chk then
										local chk_mode;
										if string.find(sys_songunlock_prm2[1],"^last.*") then
											chk_mode="last";
										elseif string.find(sys_songunlock_prm2[1],"^max.*") then
											chk_mode="max";
										elseif string.find(sys_songunlock_prm2[1],"^min.*") then
											chk_mode="min";
										elseif string.find(sys_songunlock_prm2[1],"^played.*") then
											chk_mode="played";
										else
											chk_mode="avg";
										end;
										-- [ja] めんどいんで数値以外を条件にした場合無視 
										local break_flag=false;
										if tonumber(sys_songunlock_prm2[2]) then
											-- [ja] 難易度別 
											for dif=1,7 do
												if not break_flag then
													local ret=-9999999999;
													if string.find(sys_songunlock_prm2[1],"^.*grade"..sdif_list[dif]) then
														ret=GetStageState("grade", chk_mode, sys_songunlock_prm2[3]);
													elseif string.find(sys_songunlock_prm2[1],"^.*pdp"..sdif_list[dif]) 
														or string.find(sys_songunlock_prm2[1],"^.*perdancepoints"..sdif_list[dif]) then	--[ja] DPより先にPDPを書いておかないと条件を満たしてしまう 
														ret=GetStageState("pdp", chk_mode, sys_songunlock_prm2[3])*100;
													elseif string.find(sys_songunlock_prm2[1],"^.*dp"..sdif_list[dif]) 
														or string.find(sys_songunlock_prm2[1],"^.*dancepoints"..sdif_list[dif]) then
														ret=GetStageState("dp", chk_mode, sys_songunlock_prm2[3]);
													elseif string.find(sys_songunlock_prm2[1],"^.*combo"..sdif_list[dif]) 
														or string.find(sys_songunlock_prm2[1],"^.*maxcombo"..sdif_list[dif]) then
														ret=GetStageState("combo", chk_mode, sys_songunlock_prm2[3]);
													elseif string.find(sys_songunlock_prm2[1],"^.*meter"..sdif_list[dif]) then
														ret=GetStageState("meter", chk_mode, sys_songunlock_prm2[3]);
													else
														ret=-9999999999;
													end;
													if ret>-9999999999 then
														if sys_songunlock_prm2[3]=="+" or sys_songunlock_prm2[3]=="over" then
															if ret<tonumber(sys_songunlock_prm2[2]) then
																if dif==1 then
																	diflock={false,false,false,false,false,false};
																else
																	diflock[dif-1]=false;
																end;
															else
																diflock[dif-1]=true;
															end;
																	break_flag=true;
														elseif sys_songunlock_prm2[3]=="-" or sys_songunlock_prm2[3]=="under" then
															if ret>tonumber(sys_songunlock_prm2[2]) then
																if dif==1 then
																	diflock={false,false,false,false,false,false};
																else
																	diflock[dif-1]=false;
																end;
															else
																diflock[dif-1]=true;
															end;
														end;
														break_flag=true;
													end;
												end;
											end;
										else
										-- [ja] その結果バージョン1.1で苦労したっていう 
											for dif=1,7 do
												if not break_flag then
													local ret=0;
													if string.find(sys_songunlock_prm2[1],"^.*song"..sdif_list[dif]) then
														ret=GetStageState("song", sys_songunlock_prm2[2], sys_songunlock_prm2[3]);
													end;
													if sys_songunlock_prm2[3]=="+" or sys_songunlock_prm2[3]=="over" then
														if (chk_mode=="played" and ret==0) or (chk_mode=="last" and ret<_MAXSTAGE()) then
															if dif==1 then
																diflock={false,false,false,false,false,false};
															else
																diflock[dif-1]=false;
															end;
														else
															diflock[dif-1]=true;
														end;
																break_flag=true;
													elseif sys_songunlock_prm2[3]=="-" or sys_songunlock_prm2[3]=="under" then
														if (chk_mode=="played" and ret>0) or (chk_mode=="last" and ret==_MAXSTAGE()) then
															if dif==1 then
																diflock={false,false,false,false,false,false};
															else
																diflock[dif-1]=false;
															end;
														else
															diflock[dif-1]=true;
														end;
													end;
													break_flag=true;
												end;
											end;
										end;
										if diflock[1]==false and diflock[2]==false and diflock[3]==false 
											and diflock[4]==false and diflock[5]==false and diflock[6]==false then
											diflock_chk=false;
											break;
										end;
									end;
								end;
								--[[
								if diflock[1]==false or diflock[2]==false or diflock[3]==false 
									or diflock[4]==false or diflock[5]==false or diflock[6]==false then
								--	break;
								end;
								--]]
							end;
						end;
						break;
					end;
				end;
			end;
			
			-- [ja] フラグfalse or 譜面自体が存在しない場合選択不可能に設定   
			local unlock_chk=0;
			for k=1,6 do
				if ((not gsong:HasStepsTypeAndDifficulty(GAMESTATE:GetCurrentSteps(GAMESTATE:GetMasterPlayerNumber()):GetStepsType(),dif_list[k])) or diflock[k]==false) then
					exsong_inf[foldername.."-"..dif_list[k]]=false;
					unlock_chk=unlock_chk+1;
				else
					exsong_inf[foldername.."-"..dif_list[k]]=true;
				end;
			end;
			if unlock_chk<6 then 
				exsong_inf[foldername]=true;
				load_cnt=load_cnt+1;
				exsong_fol[load_cnt]=foldername;
			else
				exsong_inf[foldername]=false;
			end;
		end;
	end;
	setenv("exsong_inf",exsong_inf);
	setenv("exsong_fol",exsong_fol);
	return load_cnt;
end;

function IsPopupExDialog()
	local angou={};
	angou["20"]=" "; angou["21"]="!"; angou["22"]="\"";angou["23"]="#"; angou["24"]="$"; angou["25"]="%"; angou["26"]="&"; angou["27"]="\'";
	angou["28"]="("; angou["29"]=")"; angou["2A"]="*"; angou["2B"]="+"; angou["2C"]=","; angou["2D"]="-"; angou["2E"]="."; angou["2F"]="/";
	angou["30"]="0"; angou["31"]="1"; angou["32"]="2"; angou["33"]="3"; angou["34"]="4"; angou["35"]="5"; angou["36"]="6"; angou["37"]="7";
	angou["38"]="8"; angou["39"]="9"; angou["3A"]=":"; angou["3B"]=";"; angou["3C"]="<"; angou["3D"]="="; angou["3E"]=">"; angou["3F"]="?";
	angou["40"]="@"; angou["41"]="A"; angou["42"]="B"; angou["43"]="C"; angou["44"]="D"; angou["45"]="E"; angou["46"]="F"; angou["47"]="G";
	angou["48"]="H"; angou["49"]="I"; angou["4A"]="J"; angou["4B"]="K"; angou["4C"]="L"; angou["4D"]="M"; angou["4E"]="N"; angou["4F"]="O";
	angou["50"]="P"; angou["51"]="Q"; angou["52"]="R"; angou["53"]="S"; angou["54"]="T"; angou["55"]="U"; angou["56"]="V"; angou["57"]="W";
	angou["58"]="X"; angou["59"]="Y"; angou["5A"]="Z"; angou["5B"]="["; angou["5C"]="\\";angou["5D"]="]"; angou["5E"]="^"; angou["5F"]="_";
	angou["60"]="`"; angou["61"]="a"; angou["62"]="b"; angou["63"]="c"; angou["64"]="d"; angou["65"]="e"; angou["66"]="f"; angou["67"]="g";
	angou["68"]="h"; angou["69"]="i"; angou["6A"]="j"; angou["6B"]="k"; angou["6C"]="l"; angou["6D"]="m"; angou["6E"]="n"; angou["6F"]="o";
	angou["70"]="p"; angou["71"]="q"; angou["72"]="r"; angou["73"]="s"; angou["74"]="t"; angou["75"]="u"; angou["76"]="v"; angou["77"]="w";
	angou["78"]="x"; angou["79"]="y"; angou["7A"]="z"; angou["7B"]="{"; angou["7C"]="|"; angou["7D"]="}"; angou["7E"]="~"; angou["7F"]="waiei";
	local EXF_Dialog={};
	setenv("EXF_Dialog",nil);
	local ret=false;
	local exstage=GetEXFolderStage();
	local group=getenv("ExGroupName");
	local dialog=GetGroupParameter(group,"Extra"..exstage.."Dialog");
	if dialog=="" then
		dialog=GetGroupParameter(group,"Extra"..exstage.."Message");
	end;
	if group~="" and dialog~="" then
		ret=true;
		local dialog_list=split(":",dialog);
		for d=1,#dialog_list do
			local prm=split("|",dialog_list[d]);
			local lprm=split("|",string.lower(dialog_list[d]));
			prm[1]=string.gsub(prm[1],"\\\\","|");
			prm[1]=string.gsub(prm[1],"\\n","\n");
			prm[1]=string.gsub(prm[1],"|","\\");
			for a=0x20,0x7F do
				local x=string.upper(string.format("%02x",a));
				prm[1]=string.gsub(prm[1],"%["..x.."%]",angou[""..x]);
			end;
			EXF_Dialog["Text"]=prm[1];
			local urlT=nil;
			local urlA=nil;
			if #prm>2 then
				for i=2,#prm do
					local prm2=split(">",prm[i]);
					local lprm2=split(">",string.lower(prm[i]));
					if #prm2>1 then
						if lprm2[1]=="type" then
							if lprm2[2]=="select" then
								EXF_Dialog["Type"]="Select";
							else
								EXF_Dialog["Type"]="Normal";
							end;
						elseif lprm2[1]=="urltype" then
							urlT=prm2[2];
						elseif lprm2[1]=="urladdress" then
							urlA=prm2[2];
						elseif #prm2>2 then
							-- [ja] 条件付き 
							local chkN={};
							local chkS="";
							local ss=STATSMAN:GetCurStageStats();
							local pss={nil,nil};
							if ss then
								pss[1]=ss:GetPlayerStageStats(EXF_GetSidePlayer(PLAYER_1));
								pss[2]=ss:GetPlayerStageStats(EXF_GetSidePlayer(PLAYER_2));
								if pss[1] then
									if lprm2[1]=="pdp" or lprm2[1]=="perdancepoints" then	-- [ja] ダンスポイント（%） 
										chkN[1]=pss[1]:GetPercentDancePoints()*100;
										chkN[2]=pss[2]:GetPercentDancePoints()*100;
									elseif lprm2[1]=="dp" or lprm2[1]=="dancepoints" then	-- [ja] ダンスポイント（数値） 
										chkN[1]=pss[1]:GetPossibleDancePoints();
										chkN[2]=pss[2]:GetPossibleDancePoints();
									elseif lprm2[1]=="combo" or lprm2[1]=="maxcombo" then	-- [ja] MAXコンボ  
										chkN[1]=pss[1]:MaxCombo();
										chkN[2]=pss[2]:MaxCombo();
									elseif lprm2[1]=="meter" then	-- [ja] 難易度 
										local st={nil,nil};
										st[1]=GAMESTATE:GetCurrentSteps(EXF_GetSidePlayer(PLAYER_1));
										st[2]=GAMESTATE:GetCurrentSteps(EXF_GetSidePlayer(PLAYER_2));
										if st[1] then
											chkN[1]=st[1]:GetMeter();
											chkN[2]=st[2]:GetMeter();
										end;
									elseif lprm2[1]=="grade" then	-- [ja] グレード 
										chkN[1]=grade[pss[1]:GetGrade()];
										chkN[2]=grade[pss[2]:GetGrade()];
									elseif lprm2[1]=="song" then	-- [ja] 曲（フォルダ名 ） 
										local song=GAMESTATE:GetCurrentSong();
										if song then
											chkS=EXF_GetSong2Folder(song);
										end;
									end;
									if lprm2[1]=="song" then
										-- [ja] 指定楽曲を 
										if prm2[3]=="+" or prm2[3]=="over" then
											-- [ja] プレイしたか 
											if chkS==prm2[2] then
												ret=true;
											else
												ret=false;
											end;
										else
											-- [ja] プレイしていないか 
											if chkS~=prm2[2] then
												ret=true;
											else
												ret=false;
											end;
										end;
									else
										-- [ja] 指定項目が 
										if prm2[3]=="+" or prm2[3]=="over" then
											-- [ja] ある数値以上か 
											local chk=(chkN[1]>=chkN[2]) and chkN[1] or chkN[2];
											if chk>=tonumber(prm2[2]) then
												ret=true;
											else
												ret=false;
											end;
										else
											-- [ja] ある数値以下か 
											local chk=(chkN[1]<=chkN[2]) and chkN[1] or chkN[2];
											if chk<=tonumber(prm2[2]) then
												ret=true;
											else
												ret=false;
											end;
										end;
									end;
								end;
							end;
						end;
					end;
					if not ret then
						-- [ja] 一つでも条件を満たしていなければアウト 
						break;
					end;
				end;
			end;
			if ret then
				if urlA then
					for a=0x20,0x7F do
						local x=string.upper(string.format("%02x",a));
						urlA=string.gsub(urlA,"%["..x.."%]",angou[""..x]);
					end;
					if not urlT then
						urlT="http";
					end;
					EXF_Dialog["Url"]=urlT.."://"..urlA;
				end;
				setenv("EXF_Dialog",EXF_Dialog);
				break;
			else
				EXF_Dialog={};
				setenv("EXF_Dialog",nil);
			end;
		end;
	end;
	return ret;
end;


-- [ja] 左側1P、右側2Pとする処理の場合そのプレイヤーが存在するかどうか 
-- [ja] もし存在しない場合は反対側のプレイヤーを返す 
function EXF_GetSidePlayer(player)
	if player==PLAYER_1 then
		if GAMESTATE:IsPlayerEnabled(PLAYER_1) then
			return PLAYER_1;
		else
			return PLAYER_2;
		end;
	else
		if GAMESTATE:IsPlayerEnabled(PLAYER_2) then
			return PLAYER_2;
		else
			return PLAYER_1;
		end;
	end;
	return PLAYER_1;
end;

--[ja] song型からフォルダ名を返す  
function EXF_GetSong2Folder(song)
	if song then
		local _t=split("/",song:GetSongDir())
		return _t[#_t-1];
	end;
	return "";
end;